/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.meteor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.meteor.FluidBlockContainer;
import wayoftime.bloodmagic.common.meteor.RandomBlockContainer;
import wayoftime.bloodmagic.common.meteor.RandomBlockTagContainer;
import wayoftime.bloodmagic.common.meteor.StaticBlockContainer;

public class MeteorLayer {
    public int layerRadius;
    public int additionalTotalWeight;
    public int minWeight = 0;
    public int totalMaxWeight = 0;
    public List<Pair<RandomBlockContainer, Integer>> weightList;
    public RandomBlockContainer fillBlock;
    public RandomBlockContainer shellBlock;

    public MeteorLayer(int layerRadius, int additionalMaxWeight, List<Pair<RandomBlockContainer, Integer>> weightList, RandomBlockContainer fillBlock) {
        this.layerRadius = layerRadius;
        this.additionalTotalWeight = additionalMaxWeight;
        this.weightList = weightList;
        this.fillBlock = fillBlock;
    }

    public MeteorLayer(int layerRadius, int additionalMaxWeight, Block fillBlock) {
        this(layerRadius, additionalMaxWeight, new ArrayList<Pair<RandomBlockContainer, Integer>>(), new StaticBlockContainer(fillBlock));
    }

    public MeteorLayer(int layerRadius, int additionalMaxWeight, Fluid fillFluid) {
        this(layerRadius, additionalMaxWeight, new ArrayList<Pair<RandomBlockContainer, Integer>>(), new FluidBlockContainer(fillFluid));
    }

    public MeteorLayer(int layerRadius, int additionalMaxWeight, TagKey<Block> fillTag) {
        this(layerRadius, additionalMaxWeight, fillTag, -1);
    }

    public MeteorLayer(int layerRadius, int additionalMaxWeight, TagKey<Block> fillTag, int staticIndex) {
        this(layerRadius, additionalMaxWeight, new ArrayList<Pair<RandomBlockContainer, Integer>>(), new RandomBlockTagContainer(fillTag, staticIndex));
    }

    public MeteorLayer addShellBlock(RandomBlockContainer shellBlock) {
        this.shellBlock = shellBlock;
        return this;
    }

    public MeteorLayer addShellBlock(TagKey<Block> tag) {
        return this.addShellBlock(tag, -1);
    }

    public MeteorLayer addShellBlock(TagKey<Block> tag, int staticIndex) {
        return this.addShellBlock(new RandomBlockTagContainer(tag, staticIndex));
    }

    public MeteorLayer addShellBlock(Block block) {
        return this.addShellBlock(new StaticBlockContainer(block));
    }

    public MeteorLayer addShellBlock(Fluid fluid) {
        return this.addShellBlock(new FluidBlockContainer(fluid));
    }

    public MeteorLayer addWeightedTag(TagKey<Block> tag, int weight) {
        return this.addWeightedTag(tag, weight, -1);
    }

    public MeteorLayer addWeightedTag(TagKey<Block> tag, int weight, int staticIndex) {
        this.weightList.add((Pair<RandomBlockContainer, Integer>)Pair.of((Object)new RandomBlockTagContainer(tag, staticIndex), (Object)weight));
        return this;
    }

    public MeteorLayer addWeightedBlock(Block block, int weight) {
        this.weightList.add((Pair<RandomBlockContainer, Integer>)Pair.of((Object)new StaticBlockContainer(block), (Object)weight));
        return this;
    }

    public MeteorLayer addWeightedFluid(Fluid fluid, int weight) {
        this.weightList.add((Pair<RandomBlockContainer, Integer>)Pair.of((Object)new FluidBlockContainer(fluid), (Object)weight));
        return this;
    }

    public MeteorLayer setMinWeight(int weight) {
        this.minWeight = weight;
        return this;
    }

    public void buildLayer(Level world, BlockPos centerPos, int emptyRadius) {
        this.recalculateMaxWeight(world.f_46441_, world);
        int radius = this.layerRadius;
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    BlockPlaceContext ctx;
                    BlockPos pos;
                    BlockState currentState;
                    if (emptyRadius >= 0 && this.checkIfSphere(emptyRadius, i, j, k) || !this.checkIfSphere(radius, i, j, k) || !(currentState = world.m_8055_(pos = centerPos.m_142082_(i, j, k))).m_60629_(ctx = new BlockPlaceContext(world, null, InteractionHand.MAIN_HAND, ItemStack.f_41583_, BlockHitResult.m_82426_((Vec3)new Vec3(0.0, 0.0, 0.0), (Direction)Direction.UP, (BlockPos)pos)))) continue;
                    if (this.shellBlock != null && this.checkIfSphereShell(radius, i, j, k)) {
                        world.m_46597_(pos, this.shellBlock.getRandomBlock(world.f_46441_, world).m_49966_());
                        continue;
                    }
                    world.m_46597_(pos, this.getRandomState(world.f_46441_, world));
                }
            }
        }
    }

    public void recalculateMaxWeight(Random rand, Level world) {
        this.totalMaxWeight = this.additionalTotalWeight;
        Iterator<Pair<RandomBlockContainer, Integer>> itr = this.weightList.iterator();
        while (itr.hasNext()) {
            Pair<RandomBlockContainer, Integer> entry = itr.next();
            Block newBlock = ((RandomBlockContainer)entry.getKey()).getRandomBlock(rand, world);
            if (newBlock == null) {
                itr.remove();
                continue;
            }
            this.totalMaxWeight += ((Integer)entry.getRight()).intValue();
        }
        this.totalMaxWeight = Math.max(this.minWeight, this.totalMaxWeight);
    }

    public BlockState getRandomState(Random rand, Level world) {
        Block block = this.fillBlock.getRandomBlock(rand, world);
        if (this.totalMaxWeight > 0) {
            int randNum = rand.nextInt(this.totalMaxWeight);
            for (Pair<RandomBlockContainer, Integer> entry : this.weightList) {
                if ((randNum -= ((Integer)entry.getValue()).intValue()) >= 0) continue;
                Block newBlock = ((RandomBlockContainer)entry.getKey()).getRandomBlock(rand, world);
                if (newBlock == null) break;
                block = newBlock;
                break;
            }
        }
        if (block != null) {
            return block.m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    public boolean checkIfSphereShell(int xR, int xOff, int yOff, int zOff) {
        if (!this.checkIfSphere(xR, xOff, yOff, zOff)) {
            return false;
        }
        return !this.checkIfSphere(xR, xOff + 1, yOff, zOff) || !this.checkIfSphere(xR, xOff - 1, yOff, zOff) || !this.checkIfSphere(xR, xOff, yOff + 1, zOff) || !this.checkIfSphere(xR, xOff, yOff - 1, zOff) || !this.checkIfSphere(xR, xOff, yOff, zOff + 1) || !this.checkIfSphere(xR, xOff, yOff, zOff - 1);
    }

    public boolean checkIfSphere(float R, float xOff, float yOff, float zOff) {
        float possOffset = 0.5f;
        return xOff * xOff + yOff * yOff + zOff * zOff <= (R + possOffset) * (R + possOffset);
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("radius", (Number)this.layerRadius);
        json.addProperty("additionalWeight", (Number)this.additionalTotalWeight);
        json.addProperty("minWeight", (Number)this.minWeight);
        if (this.weightList.size() > 0) {
            JsonArray mainArray = new JsonArray();
            for (Pair<RandomBlockContainer, Integer> weightedPair : this.weightList) {
                JsonObject jsonObj = ((RandomBlockContainer)weightedPair.getKey()).serialize((Integer)weightedPair.getValue());
                mainArray.add((JsonElement)jsonObj);
            }
            json.add("weightMap", (JsonElement)mainArray);
        }
        json.add("fill", (JsonElement)this.fillBlock.serialize());
        if (this.shellBlock != null) {
            json.add("shell", (JsonElement)this.shellBlock.serialize());
        }
        return json;
    }

    public static MeteorLayer deserialize(JsonObject json) {
        int layerRadius = GsonHelper.m_13927_((JsonObject)json, (String)"radius");
        int maxWeight = GsonHelper.m_13927_((JsonObject)json, (String)"additionalWeight");
        int minWeight = GsonHelper.m_13927_((JsonObject)json, (String)"minWeight");
        ArrayList<Pair<RandomBlockContainer, Integer>> weightList = new ArrayList<Pair<RandomBlockContainer, Integer>>();
        if (json.has("weightMap") && GsonHelper.m_13885_((JsonObject)json, (String)"weightMap")) {
            JsonArray mainArray = GsonHelper.m_13933_((JsonObject)json, (String)"weightMap");
            for (JsonElement element : mainArray) {
                JsonObject obj = element.getAsJsonObject();
                Pair<RandomBlockContainer, Integer> weightedEntry = RandomBlockContainer.deserializeWeightedPair(obj);
                if (weightedEntry == null) continue;
                weightList.add(weightedEntry);
            }
        }
        RandomBlockContainer fillBlock = null;
        if (GsonHelper.m_13894_((JsonObject)json, (String)"fill")) {
            fillBlock = RandomBlockContainer.parseEntry(GsonHelper.m_13906_((JsonObject)json, (String)"fill"));
        } else {
            JsonObject fillObj = GsonHelper.m_13930_((JsonObject)json, (String)"fill");
            fillBlock = RandomBlockContainer.deserializeContainer(fillObj);
        }
        MeteorLayer layer = new MeteorLayer(layerRadius, maxWeight, weightList, fillBlock);
        if (GsonHelper.m_13900_((JsonObject)json, (String)"shell")) {
            RandomBlockContainer shellBlock = null;
            if (GsonHelper.m_13894_((JsonObject)json, (String)"shell")) {
                shellBlock = RandomBlockContainer.parseEntry(GsonHelper.m_13906_((JsonObject)json, (String)"shell"));
            } else {
                JsonObject shellObj = GsonHelper.m_13930_((JsonObject)json, (String)"shell");
                shellBlock = RandomBlockContainer.deserializeContainer(shellObj);
            }
            layer.addShellBlock(shellBlock);
        }
        layer.setMinWeight(minWeight);
        return layer;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.layerRadius);
        buffer.writeInt(this.additionalTotalWeight);
        buffer.writeInt(this.minWeight);
        buffer.writeInt(this.weightList.size());
        for (int i = 0; i < this.weightList.size(); ++i) {
            buffer.m_130070_(((RandomBlockContainer)this.weightList.get(i).getKey()).getEntry());
            buffer.writeInt(((Integer)this.weightList.get(i).getValue()).intValue());
        }
        buffer.m_130070_(this.fillBlock.getEntry());
        if (this.shellBlock == null) {
            buffer.m_130070_("");
        } else {
            buffer.m_130070_(this.shellBlock.getEntry());
        }
    }

    public static MeteorLayer read(@Nonnull FriendlyByteBuf buffer) {
        int layerRadius = buffer.readInt();
        int maxWeight = buffer.readInt();
        int minWeight = buffer.readInt();
        int listSize = buffer.readInt();
        ArrayList<Pair<RandomBlockContainer, Integer>> weightList = new ArrayList<Pair<RandomBlockContainer, Integer>>();
        for (int i = 0; i < listSize; ++i) {
            String entry = buffer.m_130277_();
            int weight = buffer.readInt();
            if (entry.isEmpty()) continue;
            RandomBlockContainer container = RandomBlockContainer.parseEntry(entry);
            weightList.add((Pair<RandomBlockContainer, Integer>)Pair.of((Object)container, (Object)weight));
        }
        RandomBlockContainer fillBlock = RandomBlockContainer.parseEntry(buffer.m_130277_());
        MeteorLayer layer = new MeteorLayer(layerRadius, maxWeight, weightList, fillBlock);
        String shellEntry = buffer.m_130277_();
        if (!shellEntry.isEmpty()) {
            layer.addShellBlock(RandomBlockContainer.parseEntry(shellEntry));
        }
        layer.setMinWeight(minWeight);
        return layer;
    }
}

